<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Notification;

use Erlage\Photogram\Data\Dtos\Notification\NotificationLinkedContentDTO;

trait TraitNotificationProperties
{
    // primary key

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $toUserId;

    // super meta

    /**
     * @var string
     */
    protected $targetContentId;

    // linked

    /**
     * @var NotificationLinkedContentDTO
     */
    protected $linkedContent;

    // meta

    /**
     * @var string
     */
    protected $metaType;

    /**
     * @var string
     */
    protected $metaIsRead;

    /**
     * @var string
     */
    protected $metaIsTransient;

    // stamps

    /**
     * @var string
     */
    protected $stampRegistrationDate;

    /**
     * @var string
     */
    protected $stampRegistration;

    /**
     * @var string
     */
    protected $stampLastUpdate;
}
